/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class Selection
implements BIFFRecord {
    private byte[] rwTop = new byte[2];
    private byte colLeft;
    private byte[] rwBottom = new byte[2];
    private byte colRight;
    private byte[] rwActive = new byte[2];
    private byte colActive;

    public Selection() {
        this.rwTop = EndianConverter.writeShort((short)0);
        this.colLeft = 0;
        this.rwBottom = EndianConverter.writeShort((short)0);
        this.colRight = 0;
        this.rwActive = EndianConverter.writeShort((short)0);
        this.colActive = 0;
    }

    public Selection(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public short getBiffType() {
        return 29;
    }

    public Point getActiveCell() {
        Point point = new Point(this.colActive, EndianConverter.readShort((byte[])this.rwActive));
        return point;
    }

    public void setActiveCell(Point point) {
        this.colActive = (byte)point.getX();
        this.rwActive = EndianConverter.writeShort((short)((short)point.getY()));
    }

    public int read(InputStream inputStream) throws IOException {
        int n = inputStream.read(this.rwTop);
        this.colLeft = (byte)(this.colLeft + (byte)inputStream.read());
        n += inputStream.read(this.rwBottom);
        this.colRight = (byte)(this.colRight + (byte)inputStream.read());
        n += inputStream.read(this.rwActive);
        this.colActive = (byte)(this.colActive + (byte)inputStream.read());
        Debug.log((int)4, (String)("\trwTop : " + EndianConverter.readShort((byte[])this.rwTop) + " colLeft : " + this.colLeft + " rwBottom : " + EndianConverter.readShort((byte[])this.rwBottom) + " colRight : " + this.colRight + " rwActive : " + EndianConverter.readShort((byte[])this.rwActive) + " colActive : " + this.colActive));
        return n += 3;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        outputStream.write(this.rwTop);
        outputStream.write(this.colLeft);
        outputStream.write(this.rwBottom);
        outputStream.write(this.colRight);
        outputStream.write(this.rwActive);
        outputStream.write(this.colActive);
        Debug.log((int)4, (String)"Writing Selection record");
    }
}

